/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.msg;

import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.sero.util.queue.ByteQueue;

public abstract class ModbusMessage {
    protected int slaveId;

    public ModbusMessage(int slaveId) throws ModbusTransportException {
        if (slaveId < 0) {
            throw new ModbusTransportException("Invalid slave id", slaveId);
        }
        this.slaveId = slaveId;
    }

    public int getSlaveId() {
        return this.slaveId;
    }

    public abstract byte getFunctionCode();

    public final void write(ByteQueue queue) {
        ModbusUtils.pushByte(queue, this.slaveId);
        this.writeImpl(queue);
    }

    protected abstract void writeImpl(ByteQueue var1);

    protected byte[] convertToBytes(boolean[] bdata) {
        int byteCount = (bdata.length + 7) / 8;
        byte[] data = new byte[byteCount];
        for (int i = 0; i < bdata.length; ++i) {
            int n = i / 8;
            data[n] = (byte)(data[n] | (bdata[i] ? 1 : 0) << i % 8);
        }
        return data;
    }

    protected byte[] convertToBytes(short[] sdata) {
        int byteCount = sdata.length * 2;
        byte[] data = new byte[byteCount];
        for (int i = 0; i < sdata.length; ++i) {
            data[i * 2] = (byte)(0xFF & sdata[i] >> 8);
            data[i * 2 + 1] = (byte)(0xFF & sdata[i]);
        }
        return data;
    }

    protected boolean[] convertToBooleans(byte[] data) {
        boolean[] bdata = new boolean[data.length * 8];
        for (int i = 0; i < bdata.length; ++i) {
            bdata[i] = (data[i / 8] >> i % 8 & 1) == 1;
        }
        return bdata;
    }

    protected short[] convertToShorts(byte[] data) {
        short[] sdata = new short[data.length / 2];
        for (int i = 0; i < sdata.length; ++i) {
            sdata[i] = ModbusUtils.toShort(data[i * 2], data[i * 2 + 1]);
        }
        return sdata;
    }
}

