/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.sero.messaging;

import com.serotonin.modbus4j.sero.epoll.InputStreamEPollWrapper;
import com.serotonin.modbus4j.sero.epoll.Modbus4JInputStreamCallback;
import com.serotonin.modbus4j.sero.messaging.DataConsumer;
import com.serotonin.modbus4j.sero.messaging.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EpollStreamTransport
implements Transport {
    private final OutputStream out;
    private final InputStream in;
    private final InputStreamEPollWrapper epoll;

    public EpollStreamTransport(InputStream in, OutputStream out, InputStreamEPollWrapper epoll) {
        this.out = out;
        this.in = in;
        this.epoll = epoll;
    }

    @Override
    public void setConsumer(final DataConsumer consumer) {
        this.epoll.add(this.in, new Modbus4JInputStreamCallback(){

            @Override
            public void terminated() {
                EpollStreamTransport.this.removeConsumer();
            }

            @Override
            public void ioException(IOException e) {
                consumer.handleIOException(e);
            }

            @Override
            public void input(byte[] buf, int len) {
                consumer.data(buf, len);
            }

            @Override
            public void closed() {
                EpollStreamTransport.this.removeConsumer();
            }
        });
    }

    @Override
    public void removeConsumer() {
        this.epoll.remove(this.in);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.out.write(data);
        this.out.flush();
    }

    @Override
    public void write(byte[] data, int len) throws IOException {
        this.out.write(data, 0, len);
        this.out.flush();
    }
}

