/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.msg;

import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.sero.io.StreamUtils;
import com.serotonin.modbus4j.sero.util.queue.ByteQueue;

public abstract class ReadResponse
extends ModbusResponse {
    private byte[] data;

    ReadResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    ReadResponse(int slaveId, byte[] data) throws ModbusTransportException {
        super(slaveId);
        this.data = data;
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        int numberOfBytes = ModbusUtils.popUnsignedByte(queue);
        if (queue.size() < numberOfBytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data = new byte[numberOfBytes];
        queue.pop(this.data);
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushByte(queue, this.data.length);
        queue.push(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public short[] getShortData() {
        return this.convertToShorts(this.data);
    }

    public boolean[] getBooleanData() {
        return this.convertToBooleans(this.data);
    }

    public String toString(boolean numeric) {
        if (this.data == null) {
            return "ReadResponse [null]";
        }
        return "ReadResponse [len=" + (numeric ? this.data.length / 2 : this.data.length * 8) + ", " + StreamUtils.dumpHex(this.data) + "]";
    }
}

