/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.ip.tcp;

import com.serotonin.modbus4j.ModbusSlaveSet;
import com.serotonin.modbus4j.base.BaseMessageParser;
import com.serotonin.modbus4j.base.BaseRequestHandler;
import com.serotonin.modbus4j.exception.ModbusInitException;
import com.serotonin.modbus4j.ip.encap.EncapMessageParser;
import com.serotonin.modbus4j.ip.encap.EncapRequestHandler;
import com.serotonin.modbus4j.ip.xa.XaMessageParser;
import com.serotonin.modbus4j.ip.xa.XaRequestHandler;
import com.serotonin.modbus4j.sero.messaging.MessageControl;
import com.serotonin.modbus4j.sero.messaging.TestableTransport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class TcpSlave
extends ModbusSlaveSet {
    private final int port;
    final boolean encapsulated;
    private ServerSocket serverSocket;
    final ExecutorService executorService;
    final List<TcpConnectionHandler> listConnections = new ArrayList<TcpConnectionHandler>();

    public TcpSlave(boolean encapsulated) {
        this(502, encapsulated);
    }

    public TcpSlave(int port, boolean encapsulated) {
        this.port = port;
        this.encapsulated = encapsulated;
        this.executorService = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start() throws ModbusInitException {
        try {
            this.serverSocket = new ServerSocket(this.port);
            while (true) {
                Socket socket = this.serverSocket.accept();
                TcpConnectionHandler handler = new TcpConnectionHandler(socket);
                this.executorService.execute(handler);
                List<TcpConnectionHandler> list = this.listConnections;
                synchronized (list) {
                    this.listConnections.add(handler);
                }
            }
        }
        catch (IOException e) {
            throw new ModbusInitException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.getExceptionHandler().receivedException(e);
        }
        List<TcpConnectionHandler> e = this.listConnections;
        synchronized (e) {
            for (TcpConnectionHandler tch : this.listConnections) {
                tch.kill();
            }
            this.listConnections.clear();
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            this.getExceptionHandler().receivedException(e2);
        }
    }

    class TcpConnectionHandler
    implements Runnable {
        private final Socket socket;
        private TestableTransport transport;
        private MessageControl conn;

        TcpConnectionHandler(Socket socket) throws ModbusInitException {
            this.socket = socket;
            try {
                this.transport = new TestableTransport(socket.getInputStream(), socket.getOutputStream());
            }
            catch (IOException e) {
                throw new ModbusInitException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BaseRequestHandler requestHandler;
            BaseMessageParser messageParser;
            if (TcpSlave.this.encapsulated) {
                messageParser = new EncapMessageParser(false);
                requestHandler = new EncapRequestHandler(TcpSlave.this);
            } else {
                messageParser = new XaMessageParser(false);
                requestHandler = new XaRequestHandler(TcpSlave.this);
            }
            this.conn = new MessageControl();
            this.conn.setExceptionHandler(TcpSlave.this.getExceptionHandler());
            try {
                this.conn.start(this.transport, messageParser, requestHandler, null);
                TcpSlave.this.executorService.execute(this.transport);
            }
            catch (IOException e) {
                TcpSlave.this.getExceptionHandler().receivedException(new ModbusInitException(e));
            }
            while (true) {
                try {
                    this.transport.testInputStream();
                }
                catch (IOException e) {
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.conn.close();
            this.kill();
            List<TcpConnectionHandler> list = TcpSlave.this.listConnections;
            synchronized (list) {
                TcpSlave.this.listConnections.remove(this);
            }
        }

        void kill() {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                TcpSlave.this.getExceptionHandler().receivedException(new ModbusInitException(e));
            }
        }
    }
}

