/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j;

import com.serotonin.modbus4j.Modbus;
import com.serotonin.modbus4j.ProcessImage;
import com.serotonin.modbus4j.exception.ModbusInitException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class ModbusSlaveSet
extends Modbus {
    private LinkedHashMap<Integer, ProcessImage> processImages = new LinkedHashMap();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public void addProcessImage(ProcessImage processImage) {
        this.lock.writeLock().lock();
        try {
            this.processImages.put(processImage.getSlaveId(), processImage);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeProcessImage(int slaveId) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.processImages.remove(slaveId) != null;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean removeProcessImage(ProcessImage processImage) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.processImages.remove(processImage.getSlaveId()) != null;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ProcessImage getProcessImage(int slaveId) {
        this.lock.readLock().lock();
        try {
            ProcessImage processImage = this.processImages.get(slaveId);
            return processImage;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<ProcessImage> getProcessImages() {
        this.lock.readLock().lock();
        try {
            HashSet<ProcessImage> hashSet = new HashSet<ProcessImage>(this.processImages.values());
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public abstract void start() throws ModbusInitException;

    public abstract void stop();
}

