/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.locator;

import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.exception.ModbusIdException;
import com.serotonin.modbus4j.locator.BaseLocator;
import com.serotonin.modbus4j.sero.NotImplementedException;

public class BinaryLocator
extends BaseLocator<Boolean> {
    private int bit = -1;

    public BinaryLocator(int slaveId, int range, int offset) {
        super(slaveId, range, offset);
        if (!BinaryLocator.isBinaryRange(range)) {
            throw new ModbusIdException("Non-bit requests can only be made from coil status and input status ranges");
        }
        this.validate();
    }

    public BinaryLocator(int slaveId, int range, int offset, int bit) {
        super(slaveId, range, offset);
        if (BinaryLocator.isBinaryRange(range)) {
            throw new ModbusIdException("Bit requests can only be made from holding registers and input registers");
        }
        this.bit = bit;
        this.validate();
    }

    public static boolean isBinaryRange(int range) {
        return range == 1 || range == 2;
    }

    protected void validate() {
        super.validate(1);
        if (!BinaryLocator.isBinaryRange(this.range)) {
            ModbusUtils.validateBit(this.bit);
        }
    }

    public int getBit() {
        return this.bit;
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public int getRegisterCount() {
        return 1;
    }

    public String toString() {
        return "BinaryLocator(slaveId=" + this.getSlaveId() + ", range=" + this.range + ", offset=" + this.offset + ", bit=" + this.bit + ")";
    }

    @Override
    public Boolean bytesToValueRealOffset(byte[] data, int offset) {
        if (this.range == 1 || this.range == 2) {
            return new Boolean(((data[offset / 8] & 0xFF) >> offset % 8 & 1) == 1);
        }
        return new Boolean(((data[(offset *= 2) + 1 - this.bit / 8] & 0xFF) >> this.bit % 8 & 1) == 1);
    }

    @Override
    public short[] valueToShorts(Boolean value) {
        throw new NotImplementedException();
    }
}

