/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.base;

import com.serotonin.modbus4j.ModbusSlaveSet;
import com.serotonin.modbus4j.ProcessImage;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ModbusResponse;
import com.serotonin.modbus4j.sero.messaging.RequestHandler;

public abstract class BaseRequestHandler
implements RequestHandler {
    protected ModbusSlaveSet slave;

    public BaseRequestHandler(ModbusSlaveSet slave) {
        this.slave = slave;
    }

    protected ModbusResponse handleRequestImpl(ModbusRequest request) throws ModbusTransportException {
        request.validate(this.slave);
        int slaveId = request.getSlaveId();
        if (slaveId == 0) {
            for (ProcessImage processImage : this.slave.getProcessImages()) {
                request.handle(processImage);
            }
            return null;
        }
        ProcessImage processImage = this.slave.getProcessImage(slaveId);
        if (processImage == null) {
            return null;
        }
        return request.handle(processImage);
    }
}

