/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.sero.messaging;

import com.serotonin.modbus4j.sero.messaging.DataConsumer;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class InputStreamListener
implements Runnable {
    private static final int DEFAULT_READ_DELAY = 50;
    private final InputStream in;
    private final DataConsumer consumer;
    private volatile boolean running = true;
    private int readDelay = 50;

    public InputStreamListener(InputStream in, DataConsumer consumer) {
        this.in = in;
        this.consumer = consumer;
    }

    public int getReadDelay() {
        return this.readDelay;
    }

    public void setReadDelay(int readDelay) {
        if (readDelay < 1) {
            throw new IllegalArgumentException("readDelay cannot be less than one");
        }
        this.readDelay = readDelay;
    }

    public void start(String threadName) {
        Thread thread = new Thread((Runnable)this, threadName);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        InputStreamListener inputStreamListener = this;
        synchronized (inputStreamListener) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buf = new byte[1024];
        try {
            while (this.running) {
                try {
                    if (this.in.available() == 0) {
                        InputStreamListener inputStreamListener = this;
                        synchronized (inputStreamListener) {
                            try {
                                this.wait(this.readDelay);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    int readcount = this.in.read(buf);
                    this.consumer.data(buf, readcount);
                }
                catch (IOException e) {
                    this.consumer.handleIOException(e);
                    if (StringUtils.equals((CharSequence)e.getMessage(), (CharSequence)"Stream closed.")) {
                    } else if (!StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"nativeavailable")) continue;
                    break;
                }
            }
        }
        finally {
            this.running = false;
        }
    }
}

