/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.msg;

import com.serotonin.modbus4j.Modbus;
import com.serotonin.modbus4j.ProcessImage;
import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.exception.ModbusTransportException;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.sero.util.queue.ByteQueue;

public abstract class ReadBinaryRequest
extends ModbusRequest {
    private int startOffset;
    private int numberOfBits;

    public ReadBinaryRequest(int slaveId, int startOffset, int numberOfBits) throws ModbusTransportException {
        super(slaveId);
        this.startOffset = startOffset;
        this.numberOfBits = numberOfBits;
    }

    @Override
    public void validate(Modbus modbus) throws ModbusTransportException {
        ModbusUtils.validateOffset(this.startOffset);
        modbus.validateNumberOfBits(this.numberOfBits);
        ModbusUtils.validateEndOffset(this.startOffset + this.numberOfBits - 1);
    }

    ReadBinaryRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    protected void writeRequest(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.startOffset);
        ModbusUtils.pushShort(queue, this.numberOfBits);
    }

    @Override
    protected void readRequest(ByteQueue queue) {
        this.startOffset = ModbusUtils.popUnsignedShort(queue);
        this.numberOfBits = ModbusUtils.popUnsignedShort(queue);
    }

    protected byte[] getData(ProcessImage processImage) throws ModbusTransportException {
        boolean[] data = new boolean[this.numberOfBits];
        for (int i = 0; i < this.numberOfBits; ++i) {
            data[i] = this.getBinary(processImage, i + this.startOffset);
        }
        return this.convertToBytes(data);
    }

    protected abstract boolean getBinary(ProcessImage var1, int var2) throws ModbusTransportException;

    public String toString() {
        return "ReadBinaryRequest [startOffset=" + this.startOffset + ", numberOfBits=" + this.numberOfBits + "]";
    }
}

