/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j.base;

import com.serotonin.modbus4j.ExceptionResult;
import com.serotonin.modbus4j.base.SlaveAndRange;
import com.serotonin.modbus4j.locator.BaseLocator;

public class KeyedModbusLocator<K> {
    private final K key;
    private final BaseLocator<?> locator;

    public KeyedModbusLocator(K key, BaseLocator<?> locator) {
        this.key = key;
        this.locator = locator;
    }

    public K getKey() {
        return this.key;
    }

    public BaseLocator<?> getLocator() {
        return this.locator;
    }

    public String toString() {
        return "KeyedModbusLocator(key=" + this.key + ", locator=" + this.locator + ")";
    }

    public int getDataType() {
        return this.locator.getDataType();
    }

    public int getOffset() {
        return this.locator.getOffset();
    }

    public SlaveAndRange getSlaveAndRange() {
        return new SlaveAndRange(this.locator.getSlaveId(), this.locator.getRange());
    }

    public int getEndOffset() {
        return this.locator.getEndOffset();
    }

    public int getRegisterCount() {
        return this.locator.getRegisterCount();
    }

    public Object bytesToValue(byte[] data, int requestOffset) {
        try {
            return this.locator.bytesToValue(data, requestOffset);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new ExceptionResult(2);
        }
    }
}

