/*
 * Decompiled with CFR 0.152.
 */
package com.serotonin.modbus4j;

import com.serotonin.modbus4j.ProcessImage;
import com.serotonin.modbus4j.ProcessImageListener;
import com.serotonin.modbus4j.base.ModbusUtils;
import com.serotonin.modbus4j.base.RangeAndOffset;
import com.serotonin.modbus4j.exception.IllegalDataAddressException;
import com.serotonin.modbus4j.exception.ModbusIdException;
import com.serotonin.modbus4j.locator.BaseLocator;
import com.serotonin.modbus4j.locator.NumericLocator;
import com.serotonin.modbus4j.locator.StringLocator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicProcessImage
implements ProcessImage {
    private final int slaveId;
    private boolean allowInvalidAddress = false;
    private short invalidAddressValue = 0;
    private final Map<Integer, Boolean> coils = new HashMap<Integer, Boolean>();
    private final Map<Integer, Boolean> inputs = new HashMap<Integer, Boolean>();
    private final Map<Integer, Short> holdingRegisters = new HashMap<Integer, Short>();
    private final Map<Integer, Short> inputRegisters = new HashMap<Integer, Short>();
    private final List<ProcessImageListener> writeListeners = new ArrayList<ProcessImageListener>();
    private byte exceptionStatus;

    public BasicProcessImage(int slaveId) {
        ModbusUtils.validateSlaveId(slaveId, false);
        this.slaveId = slaveId;
    }

    @Override
    public int getSlaveId() {
        return this.slaveId;
    }

    public synchronized void addListener(ProcessImageListener l) {
        this.writeListeners.add(l);
    }

    public synchronized void removeListener(ProcessImageListener l) {
        this.writeListeners.remove(l);
    }

    public boolean isAllowInvalidAddress() {
        return this.allowInvalidAddress;
    }

    public void setAllowInvalidAddress(boolean allowInvalidAddress) {
        this.allowInvalidAddress = allowInvalidAddress;
    }

    public short getInvalidAddressValue() {
        return this.invalidAddressValue;
    }

    public void setInvalidAddressValue(short invalidAddressValue) {
        this.invalidAddressValue = invalidAddressValue;
    }

    public void setExceptionStatus(byte exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    public void setBinary(int registerId, boolean value) {
        RangeAndOffset rao = new RangeAndOffset(registerId);
        this.setBinary(rao.getRange(), rao.getOffset(), value);
    }

    public void setBinary(int range, int offset, boolean value) {
        if (range == 1) {
            this.setCoil(offset, value);
        } else if (range == 2) {
            this.setInput(offset, value);
        } else {
            throw new ModbusIdException("Invalid range to set binary: " + range);
        }
    }

    public synchronized void setNumeric(int registerId, int dataType, Number value) {
        RangeAndOffset rao = new RangeAndOffset(registerId);
        this.setNumeric(rao.getRange(), rao.getOffset(), dataType, value);
    }

    public synchronized void setNumeric(int range, int offset, int dataType, Number value) {
        short[] registers = new NumericLocator(this.slaveId, range, offset, dataType).valueToShorts(value);
        if (range == 3) {
            this.setHoldingRegister(offset, registers);
        } else if (range == 4) {
            this.setInputRegister(offset, registers);
        } else {
            throw new ModbusIdException("Invalid range to set register: " + range);
        }
    }

    public synchronized void setString(int range, int offset, int dataType, int registerCount, String s) {
        this.setString(range, offset, dataType, registerCount, StringLocator.ASCII, s);
    }

    public synchronized void setString(int range, int offset, int dataType, int registerCount, Charset charset, String s) {
        short[] registers = new StringLocator(this.slaveId, range, offset, dataType, registerCount, charset).valueToShorts(s);
        if (range == 3) {
            this.setHoldingRegister(offset, registers);
        } else if (range == 4) {
            this.setInputRegister(offset, registers);
        } else {
            throw new ModbusIdException("Invalid range to set register: " + range);
        }
    }

    public synchronized void setHoldingRegister(int offset, short[] registers) {
        this.validateOffset(offset);
        for (int i = 0; i < registers.length; ++i) {
            this.setHoldingRegister(offset + i, registers[i]);
        }
    }

    public synchronized void setInputRegister(int offset, short[] registers) {
        this.validateOffset(offset);
        for (int i = 0; i < registers.length; ++i) {
            this.setInputRegister(offset + i, registers[i]);
        }
    }

    public synchronized void setBit(int range, int offset, int bit, boolean value) {
        if (range == 3) {
            this.setHoldingRegisterBit(offset, bit, value);
        } else if (range == 4) {
            this.setInputRegisterBit(offset, bit, value);
        } else {
            throw new ModbusIdException("Invalid range to set register: " + range);
        }
    }

    public synchronized void setHoldingRegisterBit(int offset, int bit, boolean value) {
        short s;
        this.validateBit(bit);
        try {
            s = this.getHoldingRegister(offset);
        }
        catch (IllegalDataAddressException e) {
            s = 0;
        }
        this.setHoldingRegister(offset, this.setBit(s, bit, value));
    }

    public synchronized void setInputRegisterBit(int offset, int bit, boolean value) {
        short s;
        this.validateBit(bit);
        try {
            s = this.getInputRegister(offset);
        }
        catch (IllegalDataAddressException e) {
            s = 0;
        }
        this.setInputRegister(offset, this.setBit(s, bit, value));
    }

    public boolean getBit(int range, int offset, int bit) throws IllegalDataAddressException {
        if (range == 3) {
            return this.getHoldingRegisterBit(offset, bit);
        }
        if (range == 4) {
            return this.getInputRegisterBit(offset, bit);
        }
        throw new ModbusIdException("Invalid range to get register: " + range);
    }

    public boolean getHoldingRegisterBit(int offset, int bit) throws IllegalDataAddressException {
        this.validateBit(bit);
        return this.getBit(this.getHoldingRegister(offset), bit);
    }

    public boolean getInputRegisterBit(int offset, int bit) throws IllegalDataAddressException {
        this.validateBit(bit);
        return this.getBit(this.getInputRegister(offset), bit);
    }

    public Number getNumeric(int range, int offset, int dataType) throws IllegalDataAddressException {
        return this.getRegister(new NumericLocator(this.slaveId, range, offset, dataType));
    }

    public String getString(int range, int offset, int dataType, int registerCount) throws IllegalDataAddressException {
        return this.getRegister(new StringLocator(this.slaveId, range, offset, dataType, registerCount, null));
    }

    public String getString(int range, int offset, int dataType, int registerCount, Charset charset) throws IllegalDataAddressException {
        return this.getRegister(new StringLocator(this.slaveId, range, offset, dataType, registerCount, charset));
    }

    public synchronized <T> T getRegister(BaseLocator<T> locator) throws IllegalDataAddressException {
        int words = locator.getRegisterCount();
        byte[] b = new byte[locator.getRegisterCount() * 2];
        for (int i = 0; i < words; ++i) {
            short s;
            if (locator.getRange() == 4) {
                s = this.getInputRegister(locator.getOffset() + i);
            } else if (locator.getRange() == 3) {
                s = this.getHoldingRegister(locator.getOffset() + i);
            } else if (this.allowInvalidAddress) {
                s = this.invalidAddressValue;
            } else {
                throw new IllegalDataAddressException();
            }
            b[i * 2] = ModbusUtils.toByte(s, true);
            b[i * 2 + 1] = ModbusUtils.toByte(s, false);
        }
        return locator.bytesToValueRealOffset(b, 0);
    }

    @Override
    public synchronized boolean getCoil(int offset) throws IllegalDataAddressException {
        return this.getBoolean(offset, this.coils);
    }

    @Override
    public synchronized void setCoil(int offset, boolean value) {
        this.validateOffset(offset);
        this.coils.put(offset, value);
    }

    @Override
    public synchronized void writeCoil(int offset, boolean value) throws IllegalDataAddressException {
        boolean old = this.getBoolean(offset, this.coils);
        this.setCoil(offset, value);
        for (ProcessImageListener l : this.writeListeners) {
            l.coilWrite(offset, old, value);
        }
    }

    @Override
    public synchronized boolean getInput(int offset) throws IllegalDataAddressException {
        return this.getBoolean(offset, this.inputs);
    }

    @Override
    public synchronized void setInput(int offset, boolean value) {
        this.validateOffset(offset);
        this.inputs.put(offset, value);
    }

    @Override
    public synchronized short getHoldingRegister(int offset) throws IllegalDataAddressException {
        return this.getShort(offset, this.holdingRegisters);
    }

    @Override
    public synchronized void setHoldingRegister(int offset, short value) {
        this.validateOffset(offset);
        this.holdingRegisters.put(offset, value);
    }

    @Override
    public synchronized void writeHoldingRegister(int offset, short value) throws IllegalDataAddressException {
        short old = this.getShort(offset, this.holdingRegisters);
        this.setHoldingRegister(offset, value);
        for (ProcessImageListener l : this.writeListeners) {
            l.holdingRegisterWrite(offset, old, value);
        }
    }

    @Override
    public synchronized short getInputRegister(int offset) throws IllegalDataAddressException {
        return this.getShort(offset, this.inputRegisters);
    }

    @Override
    public synchronized void setInputRegister(int offset, short value) {
        this.validateOffset(offset);
        this.inputRegisters.put(offset, value);
    }

    @Override
    public byte getExceptionStatus() {
        return this.exceptionStatus;
    }

    @Override
    public byte[] getReportSlaveIdData() {
        return new byte[0];
    }

    private short getShort(int offset, Map<Integer, Short> map) throws IllegalDataAddressException {
        Short value = map.get(offset);
        if (value == null) {
            if (this.allowInvalidAddress) {
                return this.invalidAddressValue;
            }
            throw new IllegalDataAddressException();
        }
        return value;
    }

    private boolean getBoolean(int offset, Map<Integer, Boolean> map) throws IllegalDataAddressException {
        Boolean value = map.get(offset);
        if (value == null) {
            if (this.allowInvalidAddress) {
                return false;
            }
            throw new IllegalDataAddressException();
        }
        return value;
    }

    private void validateOffset(int offset) {
        if (offset < 0 || offset > 65535) {
            throw new ModbusIdException("Invalid offset: " + offset);
        }
    }

    private void validateBit(int bit) {
        if (bit < 0 || bit > 15) {
            throw new ModbusIdException("Invalid bit: " + bit);
        }
    }

    private short setBit(short s, int bit, boolean value) {
        return (short)(s | (value ? 1 : 0) << bit);
    }

    private boolean getBit(short s, int bit) {
        return (s >> bit & 1) == 1;
    }
}

